// Version/Precision tags are added programmatically on shader load

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;
attribute vec2 vaUV;

uniform mat4 mProj;
uniform mat4 mView;
uniform mat4 mModel;
uniform vec3 uLightPos;
uniform vec3 uEyePosition;
uniform mat4 mDepthBiasMVP;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position
varying vec2 UV; // UV

varying float fogValue;
varying vec3 ShadowCoord;

void main()
{
  C = vaColor;
  L = normalize(mat3(mView) * uLightPos);
  N = normalize(mat3(mView) * mat3(mModel) * vaNormal);
  P = vec3(mModel * vec4(vPosition, 1.0));
  UV = vaUV;

  // Fog
  #ifdef FOG
    #define FOG_A %
    #define FOG_B %

    vec3 rayDir = P - uEyePosition;
    float distance = length(rayDir);
    rayDir = normalize(rayDir);
    fogValue = FOG_A * exp(-uEyePosition.z * FOG_B) * (1.0 - exp(-distance * rayDir.z * FOG_B)) / rayDir.z;
    fogValue = clamp(fogValue, 0.0, 1.0);
  #else
    fogValue = 0.0;
  #endif

  // SHADOWS
  ShadowCoord = vec3(mDepthBiasMVP * mModel * vec4(vPosition, 1.0));

  gl_Position = mProj * mView * mModel * vec4(vPosition, 1.0);
}
